<?php 
function yobazar_child_register_scripts(){
    $parent_style = 'yobazar-style';

    wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css', array('font-awesome-5', 'yobazar-reset'), yobazar_get_theme_version() );
    wp_enqueue_style( 'yobazar-child-style',
        get_stylesheet_directory_uri() . '/style.css',
        array( $parent_style )
    );
}
add_action( 'wp_enqueue_scripts', 'yobazar_child_register_scripts' );


// Hide price and add to cart button for non-logged in users
add_filter('woocommerce_get_price_html', 'hide_price_for_guests', 10, 2);
add_filter('woocommerce_is_purchasable', 'hide_add_to_cart_for_guests', 10, 2);

function hide_price_for_guests($price, $product) {
    if (!is_user_logged_in()) {
        return '<a href="' . esc_url(wp_login_url(get_permalink())) . '" >Login to see price</a>';
    }
    return $price;
}

function hide_add_to_cart_for_guests($purchasable, $product) {
    if (!is_user_logged_in()) {
        return false;
    }
    return $purchasable;
}

// // Hide price and add to cart button for non-logged-in users
// add_filter('woocommerce_get_price_html', 'hide_price_for_guests', 10, 2);
// add_filter('woocommerce_is_purchasable', 'hide_add_to_cart_for_guests', 10, 2);

// function hide_price_for_guests($price, $product) {
//     if (!is_user_logged_in()) {
//         $register_url = wp_registration_url(); // Default WordPress registration page
//         return '<a href="' . esc_url($register_url) . '">Create an account to see price</a>';
//     }
//     return $price;
// }

// function hide_add_to_cart_for_guests($purchasable, $product) {
//     if (!is_user_logged_in()) {
//         return false;
//     }
//     return $purchasable;
// }


/**
 * @snippet       Custom Redirect for Logins @ WooCommerce My Account
 * @how-to        businessbloomer.com/woocommerce-customization
 * @author        Rodolfo Melogli, Business Bloomer
 * @compatible    WooCommerce 6
 * @community     https://businessbloomer.com/club/
 */
 
add_filter( 'woocommerce_login_redirect', 'bbloomer_customer_login_redirect', 9999 );
 
function bbloomer_customer_login_redirect( $redirect_url ) {
    $redirect_url = '/shop';
    return $redirect_url;
}
